<?php

define('HUBSPOT_TOKEN', 'pat-na1-101a8c98-0cb4-4429-aea4-e8a03cb3c8b1');
define('STRIPE_SK_TEST', '[PLEASE INPUT YOUR STRIPE KEY HERE]');
define('DEAL_PIPELINE', '730644505');
define('DEAL_STAGE_WON', '1065671260');
define('DEAL_STAGE_CART', '1065726029');
define('ORDER_TABLE_ID', '117161477');

require 'vendor/autoload.php';

\Stripe\Stripe::setApiKey(STRIPE_SK_TEST);

//Recheck availability
function checkSeats($cart){
  $productIds = array_map(function($item) {
      return $item['product_id'];
  }, $cart);
  // $url = 'https://api.hubapi.com/crm/v3/objects/products/batch/read';
  $url = 'https://api.hubapi.com/crm/v3/objects/p734313_i2_courses/batch/read';
  $payload = json_encode([
      "inputs" => array_map(function($id) {
          return ["id" => $id];
      }, $productIds),
      "properties" => array(
        'course_capacity',
        // 'seats_available',
        'seats_booked',
        'id'
      )
  ]);
  $ch = curl_init();
   curl_setopt($ch, CURLOPT_URL, $url);
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
   curl_setopt($ch, CURLOPT_POST, 1);
   curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
   curl_setopt($ch, CURLOPT_HTTPHEADER, [
       'Content-Type: application/json',
       "Authorization: Bearer " . HUBSPOT_TOKEN
   ]);

   $response = curl_exec($ch);
   curl_close($ch);

   $productData = json_decode($response, true);

   if (isset($productData['results']) && !empty($productData['results'])) {
       $result = [];
       foreach ($cart as $item) {
          $cQty = $item['qty'];
          $cID = $item['product_id'];
          foreach ($productData['results'] as $product) {
            $pID = $product['id'];
            if($cID == $pID){
              $seatsLeft = intval($product['properties']['course_capacity']) - intval($product['properties']['seats_booked']);
              // $seatsLeft = intval($product['properties']['seats_available']) - intval($product['properties']['seats_booked']);
              if($cQty > $seatsLeft){
                array_push(
                  $result,
                  array(
                    'pID' => $pID,
                    'seats_remaining' => $seatsLeft
                  )
                );
              }
            }
          }
       }
       return $result;
   }

   return [];
}

//Get Tax Rate
function calculateTax($amount, $countryName, $zip, $isBusiness){
  $countryISO = countryNameToISO($countryName);
  if (!$countryISO) {
    echo json_encode(['error' => 'Unsupported country']);
    exit;
  }
  $customerAddress = [];

  if ($countryISO === 'US') {
    $customerAddress = [
      'country' => 'US',
      'postal_code' => $zip
    ];
  } else {
    $customerAddress = [
      'country' => $countryISO
    ];
  }

  try {
    $calculation = \Stripe\Tax\Calculation::create([
        'customer_details' => [
            'address' => $customerAddress,
            'tax_ids' => $isBusiness ? [['type' => 'eu_vat', 'value' => 'DE123456789']] : [],
            'address_source' => 'billing'
        ],
        'currency' => 'usd', // required, but we won’t use this on frontend
        'line_items' => [[
            'amount' => $amount,
            'reference' => 'cart_total',
            'tax_behavior' => 'exclusive',
            'product' => 'prod_SEN9hM7Hvay9rc' //Dummy product for tax caclulations: REPLACE WITH YOUR PRODUCT ID
        ]]
    ]);

    $taxPercent = $calculation->tax_breakdown[0]->tax_rate_details->percentage_decimal;
    return json_encode(['tax_percent' => $taxPercent]);
  } catch (\Stripe\Exception\ApiErrorException $e) {
    return json_encode(['error' => $e->getMessage()]);
  }
}

function countryNameToISO($name){
  $countries = [
    'Afghanistan' => 'AF',
    'Åland Islands' => 'AX',
    'Albania' => 'AL',
    'Algeria' => 'DZ',
    'American Samoa' => 'AS',
    'Andorra' => 'AD',
    'Angola' => 'AO',
    'Anguilla' => 'AI',
    'Antarctica' => 'AQ',
    'Antigua and Barbuda' => 'AG',
    'Argentina' => 'AR',
    'Armenia' => 'AM',
    'Aruba' => 'AW',
    'Australia' => 'AU',
    'Austria' => 'AT',
    'Azerbaijan' => 'AZ',
    'Bahamas' => 'BS',
    'Bahrain' => 'BH',
    'Bangladesh' => 'BD',
    'Barbados' => 'BB',
    'Belarus' => 'BY',
    'Belgium' => 'BE',
    'Belize' => 'BZ',
    'Benin' => 'BJ',
    'Bermuda' => 'BM',
    'Bhutan' => 'BT',
    'Bolivia' => 'BO',
    'Bosnia and Herzegovina' => 'BA',
    'Botswana' => 'BW',
    'Bouvet Island' => 'BV',
    'Brazil' => 'BR',
    'British Indian Ocean Territory' => 'IO',
    'British Virgin Islands' => 'VG',
    'Brunei' => 'BN',
    'Bulgaria' => 'BG',
    'Burkina Faso' => 'BF',
    'Burundi' => 'BI',
    'Cambodia' => 'KH',
    'Cameroon' => 'CM',
    'Canada' => 'CA',
    'Cape Verde' => 'CV',
    'Cayman Islands' => 'KY',
    'Central African Republic' => 'CF',
    'Chad' => 'TD',
    'Chile' => 'CL',
    'China' => 'CN',
    'Christmas Island' => 'CX',
    'Cocos (Keeling) Islands' => 'CC',
    'Colombia' => 'CO',
    'Comoros' => 'KM',
    'Congo' => 'CG',
    'Cook Islands' => 'CK',
    'Costa Rica' => 'CR',
    "Cote d'Ivoire" => 'CI',
    'Croatia' => 'HR',
    'Cuba' => 'CU',
    'Curaçao' => 'CW',
    'Cyprus' => 'CY',
    'Czech Republic' => 'CZ',
    'Democratic Republic of the Congo' => 'CD',
    'Denmark' => 'DK',
    'Djibouti' => 'DJ',
    'Dominica' => 'DM',
    'Dominican Republic' => 'DO',
    'East Timor' => 'TL',
    'Ecuador' => 'EC',
    'Egypt' => 'EG',
    'El Salvador' => 'SV',
    'Equatorial Guinea' => 'GQ',
    'Eritrea' => 'ER',
    'Estonia' => 'EE',
    'Ethiopia' => 'ET',
    'Falkland Islands' => 'FK',
    'Faroe Islands' => 'FO',
    'Fiji' => 'FJ',
    'Finland' => 'FI',
    'France' => 'FR',
    'French Guiana' => 'GF',
    'French Polynesia' => 'PF',
    'French Southern and Antarctic Lands' => 'TF',
    'Gabon' => 'GA',
    'Gambia' => 'GM',
    'Georgia' => 'GE',
    'Germany' => 'DE',
    'Ghana' => 'GH',
    'Gibraltar' => 'GI',
    'Greece' => 'GR',
    'Greenland' => 'GL',
    'Grenada' => 'GD',
    'Guadeloupe' => 'GP',
    'Guam' => 'GU',
    'Guatemala' => 'GT',
    'Guernsey' => 'GG',
    'Guinea' => 'GN',
    'Guinea-Bissau' => 'GW',
    'Guyana' => 'GY',
    'Haiti' => 'HT',
    'Heard Island and McDonald Islands' => 'HM',
    'Honduras' => 'HN',
    'Hong Kong' => 'HK',
    'Hungary' => 'HU',
    'Iceland' => 'IS',
    'India' => 'IN',
    'Indonesia' => 'ID',
    'Iran' => 'IR',
    'Iraq' => 'IQ',
    'Ireland' => 'IE',
    'Isle of Man' => 'IM',
    'Israel' => 'IL',
    'Italy' => 'IT',
    'Jamaica' => 'JM',
    'Japan' => 'JP',
    'Jersey' => 'JE',
    'Jordan' => 'JO',
    'Kazakhstan' => 'KZ',
    'Kenya' => 'KE',
    'Kiribati' => 'KI',
    'Kuwait' => 'KW',
    'Kyrgyzstan' => 'KG',
    'Laos' => 'LA',
    'Latvia' => 'LV',
    'Lebanon' => 'LB',
    'Lesotho' => 'LS',
    'Liberia' => 'LR',
    'Libya' => 'LY',
    'Liechtenstein' => 'LI',
    'Lithuania' => 'LT',
    'Luxembourg' => 'LU',
    'Macau' => 'MO',
    'Madagascar' => 'MG',
    'Malawi' => 'MW',
    'Malaysia' => 'MY',
    'Maldives' => 'MV',
    'Mali' => 'ML',
    'Malta' => 'MT',
    'Marshall Islands' => 'MH',
    'Martinique' => 'MQ',
    'Mauritania' => 'MR',
    'Mauritius' => 'MU',
    'Mayotte' => 'YT',
    'Mexico' => 'MX',
    'Micronesia' => 'FM',
    'Moldova' => 'MD',
    'Monaco' => 'MC',
    'Mongolia' => 'MN',
    'Montenegro' => 'ME',
    'Montserrat' => 'MS',
    'Morocco' => 'MA',
    'Mozambique' => 'MZ',
    'Namibia' => 'NA',
    'Nauru' => 'NR',
    'Nepal' => 'NP',
    'Netherlands' => 'NL',
    'New Caledonia' => 'NC',
    'New Zealand' => 'NZ',
    'Nicaragua' => 'NI',
    'Niger' => 'NE',
    'Nigeria' => 'NG',
    'Niue' => 'NU',
    'Norfolk Island' => 'NF',
    'North Korea' => 'KP',
    'Northern Mariana Islands' => 'MP',
    'Norway' => 'NO',
    'Oman' => 'OM',
    'Pakistan' => 'PK',
    'Palau' => 'PW',
    'Palestine' => 'PS',
    'Panama' => 'PA',
    'Papua New Guinea' => 'PG',
    'Paraguay' => 'PY',
    'Peru' => 'PE',
    'Philippines' => 'PH',
    'Pitcairn Islands' => 'PN',
    'Poland' => 'PL',
    'Portugal' => 'PT',
    'Puerto Rico' => 'PR',
    'Qatar' => 'QA',
    'Réunion' => 'RE',
    'Romania' => 'RO',
    'Russia' => 'RU',
    'Rwanda' => 'RW',
    'Saint Barthélemy' => 'BL',
    'Saint Helena' => 'SH',
    'Saint Kitts and Nevis' => 'KN',
    'Saint Lucia' => 'LC',
    'Saint Martin' => 'MF',
    'Saint Pierre and Miquelon' => 'PM',
    'Saint Vincent and the Grenadines' => 'VC',
    'Samoa' => 'WS',
    'San Marino' => 'SM',
    'Sao Tome and Principe' => 'ST',
    'Saudi Arabia' => 'SA',
    'Senegal' => 'SN',
    'Serbia' => 'RS',
    'Seychelles' => 'SC',
    'Sierra Leone' => 'SL',
    'Singapore' => 'SG',
    'Sint Maarten' => 'SX',
    'Slovakia' => 'SK',
    'Slovenia' => 'SI',
    'Solomon Islands' => 'SB',
    'Somalia' => 'SO',
    'South Africa' => 'ZA',
    'South Georgia and the South Sandwich Islands' => 'GS',
    'South Korea' => 'KR',
    'South Sudan' => 'SS',
    'Spain' => 'ES',
    'Sri Lanka' => 'LK',
    'Sudan' => 'SD',
    'Suriname' => 'SR',
    'Svalbard and Jan Mayen' => 'SJ',
    'Swaziland' => 'SZ',
    'Sweden' => 'SE',
    'Switzerland' => 'CH',
    'Syria' => 'SY',
    'Taiwan' => 'TW',
    'Tajikistan' => 'TJ',
    'Tanzania' => 'TZ',
    'Thailand' => 'TH',
    'Togo' => 'TG',
    'Tokelau' => 'TK',
    'Tonga' => 'TO',
    'Trinidad and Tobago' => 'TT',
    'Tunisia' => 'TN',
    'Türkiye' => 'TR',
    'Turkmenistan' => 'TM',
    'Turks and Caicos Islands' => 'TC',
    'Tuvalu' => 'TV',
    'U.S. Virgin Islands' => 'VI',
    'Uganda' => 'UG',
    'Ukraine' => 'UA',
    'United Arab Emirates' => 'AE',
    'United Kingdom' => 'GB',
    'United States' => 'US',
    'United States Minor Outlying Islands' => 'UM',
    'Uruguay' => 'UY',
    'Uzbekistan' => 'UZ',
    'Vanuatu' => 'VU',
    'Vatican City' => 'VA',
    'Venezuela' => 'VE',
    'Vietnam' => 'VN',
    'Wallis and Futuna' => 'WF',
    'Western Sahara' => 'EH',
    'Yemen' => 'YE',
    'Zambia' => 'ZM',
    'Zimbabwe' => 'ZW'
  ];
  return $countries[$name] ?? null;
}

//Get contact by email
function contactByEmail($email) {
  $url = 'https://api.hubapi.com/crm/v3/objects/contacts/' . $email . '?idProperty=email&associations=company&archived=false';

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer " . HUBSPOT_TOKEN,
      "Content-Type: application/json",
    ],
  ]);

  $response = curl_exec($curl);
  $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
  $err = curl_error($curl);
  curl_close($curl);

  if (!$err && $httpCode === 200) {
    $contact_details = json_decode($response, true);
    $contact_id = $contact_details['id'];
    $company_id = $contact_details['associations']['companies']['results'][0]['id'] ?? null;

    return [
      'contact_id' => $contact_id,
      'company_id' => $company_id
    ];
  }

  return null;
}

function createContactByEmail($email) {
  $url = 'https://api.hubapi.com/crm/v3/objects/contacts';
  $postData = json_encode([
    'properties' => [
      'email' => $email,
    ]
  ]);

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postData,
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer " . HUBSPOT_TOKEN,
      "Content-Type: application/json"
    ],
  ]);

  $response = curl_exec($curl);
  $err = curl_error($curl);
  $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
  curl_close($curl);

  if (!$err && $httpCode === 201) {
    $data = json_decode($response, true);
    return $data['id'] ?? null;
  } else {
    file_put_contents(__DIR__ . '/custom_log.txt', "Failed to create contact for email $email\n$response\n\n", FILE_APPEND);
    return null;
  }
}


//Create a deal
function createDeal($cart, $dealname, $contactDetails, $tax, $currency, $total){
  $contact_id = $contactDetails['contact_id'];
  $company_id = $contactDetails['company_id'];

  $curl = curl_init();
  $deal_arr = array(
      'properties' => array(
          'dealname' => $dealname,
          'pipeline' => DEAL_PIPELINE,
          'dealstage' => DEAL_STAGE_WON,
          'amount' => (round(floatval($total), 2) + round(floatval($tax), 2))
      ),
      'associations' => array(
          array(
              'to' => array(
                  'id' => $contact_id
              ),
              'types' => array(
                  array(
                      'associationCategory' => 'HUBSPOT_DEFINED',
                      'associationTypeId' => 3
                  )
              )
          )
      )
  );

  foreach ($cart as $assocc_line_item) {

    $course_assoc = array(
      'to' => array(
          'id' => $assocc_line_item['product_id']
      ),
      'types' => array(
          array(
              'associationCategory' => 'USER_DEFINED',
              'associationTypeId' => 18
          )
      )
    );

    array_push($deal_arr['associations'], $course_assoc);

  }

  if (!is_null($company_id)) {
    $co_assoc_arr = array(
      'to' => array(
          'id' => $company_id
      ),
      'types' => array(
          array(
              'associationCategory' => 'HUBSPOT_DEFINED',
              'associationTypeId' => 5
          )
      )
    );
    array_push($deal_arr['associations'], $co_assoc_arr);
  }

  $deal_json = json_encode($deal_arr);

  curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.hubapi.com/crm/v3/objects/deals",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => $deal_json,
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer " . HUBSPOT_TOKEN,
      "Content-Type: application/json",
    ],
  ]);

  $response_deal = curl_exec($curl);
  $err_deal = curl_error($curl);

  curl_close($curl);

  if ($err_deal) {
    return 0;
  } else {
    $deal_details = json_decode($response_deal, true);
    $deal_id = $deal_details['id'];
    $line_items_arr = array(
        'inputs' => array(

        )
    );

    foreach ($cart as $line_item) {

      $this_li_array = array(
          'properties' => array(
              'name' => $line_item['name'],
              'quantity' => $line_item['qty'],
              'price' => round(convertCurrencyToUSD(floatval($line_item['price']), $currency), 2),
          ),
          'associations' => array(
              array(
                  'to' => array(
                      'id' => $deal_id
                  ),
                  'types' => array(
                      array(
                          'associationCategory' => 'HUBSPOT_DEFINED',
                          'associationTypeId' => 20
                      )
                  )
              )
          )
      );

      array_push($line_items_arr['inputs'], $this_li_array);

      updateProductSeatsBooked($line_item['product_id'], $line_item['qty']);
      $order_date = $currentDate = date('F j, Y');
      addHubDBRow($contact_id, $deal_id, $line_item['product_id'], $order_date, $line_item['dates'], $line_item['location'], $line_item['delivery'], $line_item['name'], intval($line_item['qty']), 0, round(convertCurrencyToUSD(floatval($line_item['price']), $currency), 2));

    }

    $tax_li_array = array(
        'properties' => array(
            'name' => 'Tax',
            'quantity' => 1,
            'price' => round($tax, 2),
        ),
        'associations' => array(
            array(
                'to' => array(
                    'id' => $deal_id
                ),
                'types' => array(
                    array(
                        'associationCategory' => 'HUBSPOT_DEFINED',
                        'associationTypeId' => 20
                    )
                )
            )
        )
    );

    array_push($line_items_arr['inputs'], $tax_li_array);

    $line_items_json = json_encode($line_items_arr);

    $curl = curl_init();

    curl_setopt_array($curl, [
      CURLOPT_URL => "https://api.hubapi.com/crm/v3/objects/line_items/batch/create",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => $line_items_json,
      CURLOPT_HTTPHEADER => [
        "Authorization: Bearer " . HUBSPOT_TOKEN,
        "Content-Type: application/json",
      ],
    ]);

    $response_li = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      return 0;
    } else {
      return $deal_id;
    }
  }
}

function convertCurrencyToUSD($amount, $fromCurrency) {
    $url = "https://open.er-api.com/v6/latest/" . urlencode($fromCurrency);

    $response = @file_get_contents($url);
    if ($response === false) {
        echo "Error fetching exchange rates.";
        return null;
    }

    $data = json_decode($response, true);
    if (!isset($data['rates']['USD'])) {
        echo "USD rate not available.";
        return null;
    }

    $rate = round($data['rates']['USD'], 2);
    $convertedAmount = ound($amount, 2) * $rate;
    $convertedAmount = round($amount * $rate, 2);
    return $convertedAmount;
}


//Update seats after booking
function updateProductSeatsBooked($productId, $qty) {
  $url = 'https://api.hubapi.com/crm/v3/objects/p734313_i2_courses/' . $productId . '?properties=seats_booked&archived=false';
  // $url = 'https://api.hubapi.com/crm/v3/objects/products/' . $productId . '?properties=seats_booked&archived=false';

  // Step 1: Fetch current product details
  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer " . HUBSPOT_TOKEN,
      "Content-Type: application/json",
    ],
  ]);

  $response = curl_exec($curl);
  $err = curl_error($curl);
  curl_close($curl);

  if ($err) {

  }

  $product = json_decode($response, true);

  if (!isset($product['properties']['seats_booked'])) {

  }

  // Step 2: Increment seats_booked
  $currentSeats = intval($product['properties']['seats_booked']);
  $newSeats = $currentSeats + intval($qty);

  // Step 3: Update product with new seats_booked value
  $updateCurl = curl_init();
  curl_setopt_array($updateCurl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "PATCH",
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer " . HUBSPOT_TOKEN,
      "Content-Type: application/json",
    ],
    CURLOPT_POSTFIELDS => json_encode([
      'properties' => [
        'seats_booked' => (string)$newSeats  // HubSpot expects string values
      ]
    ])
  ]);

  $updateResponse = curl_exec($updateCurl);
  $updateErr = curl_error($updateCurl);
  curl_close($updateCurl);

  if ($updateErr) {

  } else {

  }

}

function addContactToCourse($contact_email, $course_id, $hubDBrow) {
  $contact = contactByEmail($contact_email);

  if (!$contact || !isset($contact['contact_id'])) {
    $contact_id = createContactByEmail($contact_email);
    if (!$contact_id) {
      file_put_contents(__DIR__ . '/custom_log.txt', "Failed to create contact for email: $contact_email\n", FILE_APPEND);
      return;
    }
  } else {
    $contact_id = $contact['contact_id'];
  }

  $url = "https://api.hubapi.com/crm/v4/objects/contact/{$contact_id}/associations/p734313_i2_courses/{$course_id}";

  $body = json_encode([
    [
      "associationCategory" => "USER_DEFINED",
      "associationTypeId" => 20
    ]
  ]);

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "PUT",
    CURLOPT_POSTFIELDS => $body,
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer " . HUBSPOT_TOKEN,
      "Content-Type: application/json"
    ],
  ]);

  $response = curl_exec($curl);
  $err = curl_error($curl);
  curl_close($curl);

  if ($err) {
    file_put_contents(__DIR__ . '/custom_log.txt', "Association error:\n" . $err . "\n\n", FILE_APPEND);
  } else {
    file_put_contents(__DIR__ . '/custom_log.txt', "Association response:\n" . $response . "\n\n", FILE_APPEND);
  }

  incrementSeatsUsed($hubDBrow);
}


function addHubDBRow($contact_id, $order_id, $course_id, $order_date, $courses_dates, $course_location, $course_type, $course_name, $seats_booked, $seats_used, $total) {

    $headers = [
        "Authorization: Bearer " . HUBSPOT_TOKEN,
        "Content-Type: application/json"
    ];

    // Step 1: Add the row
    $data = [
        'values' => [
            'contact_id'      => $contact_id,
            'order_id'        => $order_id,
            'course_id'       => $course_id,
            'order_date'      => $order_date,
            'course_dates'    => $courses_dates,
            'course_location' => $course_location,
            'course_type'     => $course_type,
            'course_name'     => $course_name,
            'seats_booked'    => $seats_booked,
            'seats_used'      => $seats_used,
            'total'           => $total
        ]
    ];

    $addRowUrl = "https://api.hubapi.com/cms/v3/hubdb/tables/" . ORDER_TABLE_ID . "/rows";
    $ch = curl_init($addRowUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => $headers,
        CURLOPT_POSTFIELDS     => json_encode($data)
    ]);
    $response = curl_exec($ch);
    $error    = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    file_put_contents(__DIR__ . '/custom_log.txt', "Response:\n" . $response . "\n\n", FILE_APPEND);

    if ($error || $httpCode < 200 || $httpCode >= 300) {
      file_put_contents(__DIR__ . '/custom_log.txt', "Error:\n" . $error . "\n\n", FILE_APPEND);
    }

    // Step 2: Publish the table
    $publishUrl = "https://api.hubapi.com/cms/v3/hubdb/tables/" . ORDER_TABLE_ID . "/draft/publish";
    $ch = curl_init($publishUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_HTTPHEADER     => $headers
    ]);
    $publishResponse = curl_exec($ch);
    $publishError    = curl_error($ch);
    $publishHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

}

function incrementSeatsUsed($hubDBrow) {
    $headers = [
        "Authorization: Bearer " . HUBSPOT_TOKEN,
        "Content-Type: application/json"
    ];

    // Step 1: Get the existing draft row data by ID
    $getUrl = "https://api.hubapi.com/cms/v3/hubdb/tables/" . ORDER_TABLE_ID . "/rows/$hubDBrow?draft=true";
    $ch = curl_init($getUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers
    ]);
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) return ['error' => "Fetch error: $error"];

    $rowData = json_decode($response, true);
    if (!isset($rowData['values'])) return ['error' => 'Invalid or missing row data'];

    $currentSeatsUsed = isset($rowData['values']['seats_used']) ? (int)$rowData['values']['seats_used'] : 0;
    $newSeatsUsed = $currentSeatsUsed + 1;

    // Step 2: Update the seats_used field via PATCH
    $updateUrl = "https://api.hubapi.com/cms/v3/hubdb/tables/" . ORDER_TABLE_ID . "/rows/$hubDBrow/draft";

    $updateCurl = curl_init();
    curl_setopt_array($updateCurl, [
        CURLOPT_URL => $updateUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "PATCH",
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => json_encode([
            'values' => [
                'seats_used' => (int)$newSeatsUsed
            ]
        ])
    ]);

    $updateResponse = curl_exec($updateCurl);
    $updateErr = curl_error($updateCurl);
    curl_close($updateCurl);

    if ($updateErr) return ['error' => 'Update error: ' . $updateErr];

    // Step 3: Publish the updated table
    $publishUrl = "https://api.hubapi.com/cms/v3/hubdb/tables/" . ORDER_TABLE_ID . "/draft/publish";
    $ch = curl_init($publishUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => $headers
    ]);
    $publishResponse = curl_exec($ch);
    curl_close($ch);

    return ['success' => true, 'new_seats_used' => $newSeatsUsed];
}




?>
